<?php
error_reporting(E_ALL);
ini_set('display_errors', 1); // Turn off error display in the browser
include "dbconnect.php";
include "includes/configuration.php";
// Assuming you have already connected to the database

// Fetch data from the TouristSite table
$sql = "SELECT * FROM TouristSite";
$result = mysqli_query($conn, $sql);

// Check if there are any records
if (mysqli_num_rows($result) > 0) {
    // Output each record as a separate HTML table
    while ($row = mysqli_fetch_assoc($result)) {
        echo '<table border="0" width="100%">';
        
        foreach ($row as $column => $value) {
            echo "<tr><td style='background-color:#F8F9F9;'>$column</td></tr><tr><td>$value</td></tr>";
            // Check if the column is the 'CoverImage' column
            if ($column === 'CoverImage' && !empty($value)) {
                echo "<tr>
                <td>Image</td></tr><tr><td><img src='$value' alt='Cover Image' style='max-width: 100%; max-height: 400px;'>
                </td>
                </tr>";
            }
        }
        echo '</table>';
    }
} else {
    echo "No records found";
}

// Free result set
mysqli_free_result($result);

// Close connection
mysqli_close($conn);
?>
