<?php
error_reporting(E_ALL);
ini_set('display_errors', 1); // Turn off error display in the browser

include "dbconnect.php";
include "includes/configuration.php";
// Check if the connection was successful
if ($conn->connect_error) {
    die(json_encode([
        'status' => 'error',
        'message' => 'Database connection failed: ' . $conn->connect_error
    ]));
}

// Query to fetch all categories
$sql = "SELECT * FROM TouristSite ORDER BY Title";
$result = mysqli_query($conn,$sql);

// Prepare an array to hold the categories
$titles = [];

if ($result->num_rows > 0) {
    // Fetch all rows and add them to the categories array
    while ($row = $result->fetch_assoc()) {
        $titles[] = $row;
    }
}

// Set the HTTP header for JSON output
header('Content-Type: application/json');

// Return the categories as JSON
echo json_encode([
    'status' => 'success',
    'data' => $titles
]);

// Close the database connection
$conn->close();
?>
